/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.lib;

import javax.annotation.Nonnull;
import net.minecraftforge.fluids.FluidStack;

public class HashedFluid {
    @Nonnull
    private final FluidStack fluidStack;
    private final int hashCode;

    public static HashedFluid create(@Nonnull FluidStack stack) {
        return new HashedFluid(new FluidStack(stack, 1));
    }

    public static HashedFluid raw(@Nonnull FluidStack stack) {
        return new HashedFluid(stack);
    }

    private HashedFluid(@Nonnull FluidStack stack) {
        this.fluidStack = stack;
        this.hashCode = this.initHashCode();
    }

    @Nonnull
    public FluidStack getStack() {
        return this.fluidStack;
    }

    @Nonnull
    public FluidStack createStack(int size) {
        if (size <= 0 || this.fluidStack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return new FluidStack(this.fluidStack, size);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof HashedFluid)) return false;
        HashedFluid other = (HashedFluid)obj;
        if (this.fluidStack.isEmpty()) return false;
        if (!this.fluidStack.isFluidEqual(other.fluidStack)) return false;
        return true;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int initHashCode() {
        int code = 1;
        code = 31 * code + this.fluidStack.getFluid().hashCode();
        if (this.fluidStack.hasTag()) {
            code = 31 * code + this.fluidStack.getTag().hashCode();
        }
        return code;
    }
}

